#!/usr/bin/perl

use strict;
use warnings;
use DBI;
use Chart::Pie;

my $png  = 'residence.png';
my $dbh  = DBI->connect("DBI:CSV:f_dir=./;csv_sep_char=\\,");

my $stmt = q~SELECT Country_of_residence FROM perlsurvey_de~;
my $sth  = $dbh->prepare( $stmt );
$sth->execute;

my %hash;
while( my ($country) = $sth->fetchrow_array ){
   $hash{$country}++;
}

my @countries = keys %hash;
my @values    = values %hash;

my @sorted    = sort{ $values[$b] <=> $values[$a] }0..$#values;

my ($width,$height) = (400,200);


my $chart = Chart::Pie->new($width,$height);

$chart->set(
    title              => 'Perl-Umfrage (DE)',
    x_label            => 'Lnder',
    y_label            => 'Anzahl',
    transparent        => 'false',
    min_val            => 0,
    legend             => 'right',
);
    

$chart->add_dataset( @countries[@sorted] );
$chart->add_dataset( @values[@sorted] );

$chart->png( $png );