#!/usr/bin/perl
use Device::USB ;

my $timeout = 500 ;
my $usb = Device::USB -> new() ;
my $dev = $usb -> find_device ( 0x04a9 , 0x2224 ) ;
$dev -> open() ;
print 'libusb:xxx:' , $dev -> filename() , "\n" ;

dispreg ( 'd0' ) ;
dispreg ( '46' ) ;
canon_set ( '02' , '01' ) ;
canon_set ( '02' , '00' ) ;
canon_set ( '01' , '00' ) ;
canon_set ( '01' , '28' ) ;
canon_set ( 'a0' , '04' ) ;
canon_set ( 'a0' , '05' ) ;
canon_set ( '01' , '28' ) ;
canon_set ( '04' , '0c' ) ;
canon_set ( '05' , '00' ) ;
canon_set ( '06' , '00' ) ;
canon_set ( '90' , '27' ) ;
canon_set ( '92' , 'f7' ) ;
canon_set ( '94' , 'f7' ) ;
canon_set ( '93' , '00' ) ;
canon_set ( '91' , '1f' ) ;

while ( 1 )
{
  dispreg ( '91' ) ;
  sleep ( 1 ) ;
}

1 ;

sub canon_set
{
  my ( $reg , $val ) = @_ ;
  my $data = '00 ' . $reg . ' 01 00 ' . $val ;
  my $cnt = $dev -> bulk_write ( hex('02') , hex2bin($data) , $timeout ) ;

  if ( $cnt < 0 )
  {
    die ( join ( ' ' , 'ERROR: canon_set' , $cnt , $reg , '=' , $val ) ) ;
  }

  print 'SET ' , $reg , ' ' , $val , "\n" ;
}

sub canon_get
{
  my ( $reg ) = @_ ;
  my $data = '01 ' . $reg . ' 01 00' ;
  my $cnt = $dev -> bulk_write ( hex('02') , hex2bin($data) , $timeout ) ;

  if ( $cnt < 0 )
  {
    die ( join ( ' ' , 'ERROR: canon_get' , $cnt , $reg ) ) ;
  }

  #--- warten bis Scanner die Daten bereit hat ---
  select ( undef , undef , undef , 0.001 ) ;

  my $data = ' ' ;
  my $cnt = $dev -> bulk_read ( hex('83') , $data , 1 , $timeout ) ;

  if ( $cnt < 0 )
  {
    error ( 'canon_get' , $cnt , $reg , '(bulk_read 0x83)' ) ;
  }

  $data = bin2hex ( $data ) ;
  return ( $data ) ;
}

sub dispreg
{
  my ( $reg ) = @_ ;
  my $data = canon_get ( $reg ) ;
  print $reg , ' = ' , $data , '  ' , sprintf('%08b',hex($data)) , "\n" ;
}

sub hex2dez
{
  my ( $txt ) = @_ ;
  $txt =~ s![\da-f]+:!!ig ;
  $txt =~ s!\A\s+!! ;
  $txt =~ s!\s+\Z!! ;
  my @data = split ( m!\s+! , $txt ) ;
  map { $_ = hex ( $_ ) } ( @data ) ;
  return ( @data ) ;
}

sub bin2hex
{
  my ( $data ) = @_ ;
  my @data = unpack ( 'C*' , $data ) ;
  my $anz = @data ;
  my $hex = sprintf ( '%02x ' x $anz , @data ) ;
  return ( $hex ) ;
}

sub hex2bin
{
  my ( $txt ) = @_ ;
  my @data = hex2dez ( $txt ) ;
  my $data = pack ( 'C*' , @data ) ;
  return ( $data ) ;
}