#!/usr/bin/perl
use Device::USB ;

my $usb = Device::USB -> new() ;
my $dev = $usb -> find_device ( 0x04a9 , 0x2224 ) ;
$dev -> open() ;

display ( 'bcdUSB' , $dev -> bcdUSB() ) ;
display ( 'bDeviceClass' , $dev -> bDeviceClass() ) ;
display ( 'bDeviceSubClass' , $dev -> bDeviceSubClass() ) ;
display ( 'bDeviceProtocol' , $dev -> bDeviceProtocol() ) ;
display ( 'bMaxPacketSize0' , $dev -> bMaxPacketSize0() ) ;
display ( 'idVendor'  , sprintf('0x%04X',$dev -> idVendor()) ) ;
display ( 'idProduct' , sprintf('0x%04X',$dev -> idProduct()) ) ;
display ( 'bcdDevice' , $dev -> bcdDevice() ) ;
display ( 'iManufacturer' , $dev -> iManufacturer() , 1 ) ;
display ( 'iProduct' , $dev -> iProduct() , 1 ) ;
display ( 'iSerialNumber' , $dev -> iSerialNumber() , 1 ) ;
display ( 'bNumConfigurations' , $dev -> bNumConfigurations() ) ;

for ( $i = 0 ; $i < $dev -> bNumConfigurations() ; $i ++ )
{
  display ( ' <configuration ' . $i . '>' ) ;
  $cfg = $dev -> get_configuration ( $i ) ;
  display ( ' wTotalLength' , $cfg -> wTotalLength() ) ;
  display ( ' bNumInterfaces' , $cfg -> bNumInterfaces() ) ;
  display ( ' bConfigurationValue' , $cfg -> bConfigurationValue() ) ;
  display ( ' iConfiguration' , $cfg -> iConfiguration() ) ;
  display ( ' bmAttributes' , $cfg -> bmAttributes() , 'Remote Wakeup' ) ;
  display ( ' MaxPower' , $cfg -> MaxPower() . ' mA' ) ;
}

sub display
{
  my ( $key , $val , $txt ) = @_ ;
  my $pad = ' ' x 22 ;
  $key = substr ( $key . $pad , 0 , 22 ) ;
  if ( $txt == 1 ) { $txt = $dev -> get_string_simple ( $val ) ; }
  if ( $txt ) { $txt = ' (' . $txt . ')' ; }
  print ( $key , $val , $txt , "\n" ) ;
}