#!/usr/bin/perl

use YAML::Tiny;

my $string = do{ local $/; <DATA> };
for( 1..1_000_000 ){
  my $yaml   = YAML::Tiny->read_string( $string );
  my $config = $yaml->[0];

  my $code = '';
  variable_declaration( \$code, $config->{root} );
}

print time - $^T,"\n";

sub variable_declaration{
    my ($coderef,$config) = @_;
    
    for my $name ( keys %$config ){
        if( ref($config->{$name}) eq 'HASH' ){
            declare_hash( $coderef, $config->{$name}, $name );
        }
    }
}

sub declare_hash{
    my ($coderef,$config,$name) = @_;
    
    $$coderef .= 'my %' . $name . " = (\n";
    
    for my $key ( keys %$config ){
        my $val = $config->{$key}->{value};
           $val = $config->{$key}->{type} eq 'qr' ? "qr/$val/" : $val;
        $$coderef  .= "$key => $val,\n"
    }

    $$coderef .= ");\n";
}

__DATA__
---
root:
  regex:
    nameCheck:
      type: qr
      value: tr0nix
    nrCheck:
      type: qr
      value: ^\d$
    emptyCheck:
      type: qr
      value: ^$