 package TieMyHashCI;
 use warnings;
 use strict;
 use Carp qw(croak);

 sub TIEHASH {
     my( $class ) = @_;
     return bless( {}, $class );
 }

 sub STORE {
     my( $self, $key, $value ) = @_;
     $self->{ lc $key } = { originalKey => $key, value => $value };
 }

 sub FETCH {
     my( $self, $key ) = @_;

     # Fehler bei Lesezugriff auf nicht existierenden Key?
     croak( "Fehler: key '$key' existiert nicht" )
         unless exists $self->{ lc $key };
     return $self->{ lc $key }->{value};
 }

 sub CLEAR { # wenn hash leere Liste zugewiesen wird
     my $self = shift;
     $self = {};
 }

 # die folgenden Methoden sind 1:1 mappings, nur mit lowercase
 sub DELETE {
     my( $self, $key ) = @_;
     return delete $self->{lc $key};
 }
 sub EXISTS {
     my( $self, $key ) = @_;
     return exists $self->{ lc $key };
 }
 sub SCALAR {
     my $self = shift;
     return scalar %{ $self} ;
 }

 # wenn man mit each oder keys ber einen Hash iteriert, wird bei jedem
 # Aufruf von each das nchste Schlssel-/Wertpaar zurckgegeben.
 # Beim ersten Mal wird FIRSTKEY aufgerufen, danach NEXTKEY, solange
 # Werte vorhanden sind.
 sub FIRSTKEY {
     my $self = shift;
     my $a = keys %{ $self }; # resette each iterator
     return $self->_mapEachKey2OriginalKey();
 }

 sub NEXTKEY {
     # $lastKey ist der letzte Key, ueber den iteriert wurde
     my( $self, $lastKey ) = @_;
     return $self->_mapEachKey2OriginalKey();
 }

 sub _mapEachKey2OriginalKey {
     my( $self ) = @_;

     my $keyLc = each %{ $self };
     ( defined $keyLc )
         ? return $self->{$keyLc}->{originalKey}
         : return;
 }

 sub UNTIE {
     my $self = shift;
     undef $self; # ist hier eigentlch ueberfluessig
 }

 # ------------------------------------------------------------
 1; # modules have to return a true value
