 package TieMyTime;
 use warnings;
 use strict;

 use POSIX (); # wird zum Formatieren der Uhrzeit verwendet (oder Datum?)

 # TIESCALAR wird aufgerufen, wenn eine Variable an 'TieMyTime' gebunden
 # wird.
 sub TIESCALAR {
     my( $class, $format ) = @_;

     $format = '%H:%M:%S' unless defined $format; # falls leer, Standard

     # Hashreferenz als Objekt erstellen, und darin das Format speichern
     my $self = bless( { format => $format }, $class );

     # und zurckgeben
     return $self;
 }

 sub FETCH {
     my( $self ) = @_;

     # einfach aktuelle Uhrzeit ermitteln, formatieren und zurueckgeben
     return POSIX::strftime( $self->{format}, localtime(time) );
 }

 sub STORE {
     # $newFormat bekommt den zugewiesenen Wert
     my( $self, $newFormat ) = @_;

     # neues Format setzen
     $self->{format} = $newFormat;

     return;
 }

 # UNTIE wird bei untie( $actualTime) aufgerufen:
 sub UNTIE {
     my( $self ) = @_;
     print "Untie aufgerufen\n";
 }

 # Wenn es am Ende nochwas aufzuraeumen gibt, kann man dafuer auch
 # DESTROY implementieren. Meist ist es jedoch besser, in UNTIE
 # aufzuraeumen.
 sub DESTROY {
     my( $self ) = @_;
     print "Ende der Zeit\n";
 }

 1;
