#!/usr/bin/perl

use Benchmark::ProgressBar qw(:all);

my @dates;

for( 0 .. 1000 ){
    my $str = (int rand 31) . '-' . ( ( int rand 100 ) + 2000 );
    push @dates, $str;
}

cmpthese(
    100000,
    {
        test1 => sub{ my @array = map{$_->[1]}
                                  sort{$b->[0]<=>$a->[0]}
                                  map{[join('', reverse map {sprintf "%04d", $_}split /-/),$_]}@dates
        },
        test2 => sub{ my @array = map { /^(....)(..)$/; .$2-$1. }
                                  sort { $a <=> $b }
                                  map { sprintf("%04d%02d", reverse /^(\d+)-(\d+)$/) } @dates;
        },
    }
);
