#!/usr/bin/perl

use strict;
use warnings;
use HTML::Parser;
# Im DATA-Bereich soll der gleich HTML-
# Code stehen wie im RegEx-Beispiel
my $content = do{ local $/; <DATA> };
my $description = "";
my $parser = HTML::Parser->new();

$parser->handler(
       start => \&_start, "tagname,attr" );
$parser->parse( $content );

print $description;

sub _start {
     my ($tag,$attr) = @_;
     return unless $tag eq "meta";
     return unless $attr->{name} eq "description";
     $description = $attr->{content};
}

__DATA__
<html>
  <head>
    <meta name="description" content="Beschreibung">
  </head>
  <body>
    <h1>Test</h1>
  </body>
</html>
