#!/usr/bin/perl

use strict;
use warnings;
use Web::Scraper;

# Im DATA-Bereich soll der gleich HTML-
# Code stehen wie im RegEx-Beispiel
my $content = do{ local $/; <DATA> };
my $parser = scraper {
    process 'meta[name="description"]',
             description => '@content';
};
my $result = $parser->scrape( $content );
print $result->{description};

__DATA__
<html>
  <head>
    <meta name="description" content="Beschreibung">
  </head>
  <body>
    <h1>Test</h1>
  </body>
</html>
