#!/usr/bin/perl
use AI::Prolog;

my $database = <<'END_PROLOG';
elter( heike,robert ).
elter( thomas,robert ).
elter( thomas,lisa ).
elter( robert,anna ).
elter( robert,petra ).
elter( petra,jakob ).
grosselter( X,Y ) :- elter( X,Z ), elter( Z,Y ).
urgrosselter(X,Y) :- grosselter(X,Z), elter(Z,Y).
END_PROLOG

my $prolog = AI::Prolog->new($database);
$prolog->query("urgrosselter(heike,jakob).");
my @results;
while (my $result = $prolog->results) {
  push(@results,$result->[1]);
}
print join(" und ",@results)," sind die Urgrosseltern von Jakob.\n";