#!/usr/bin/perl

use strict;
use warnings;
use FindBin ();
use Algorithm::SVM;
use Algorithm::SVM::DataSet;

my $home            = $FindBin::Bin.'/';
my $trainingsfile   = $home.'car_data_main.txt';
my $predictionsfile = $home.'car_data.txt';
my $model           = $home.'new-sample.model';

my %mapping = (
    0 => {vhigh => 1,    high    => 1,    
          med   => -1,   low     => -1,   },
    1 => {vhigh => 1,    high    => 0.66,
          med   => 0.33, low     => 0,    },
    2 => {2     => 0.4,  3       => 0.6 , 
           4     => 0.8,  '5more' => 1,    },
    3 => {2     => 0.33, 4       => 0.66, 
          more  => 0.99,                  },
    4 => {small => 0.33, med     => 0.66, 
          big   => 0.99,                  },
   5 => {low   => 0.33, med     => 0.66, 
          high  => 0.99,                  },
  );
              
train_svm($model,$trainingsfile,%mapping);
predict($model,$predictionsfile,%mapping);

#--------------------------------------------------#
#                 Subroutines                      #
#--------------------------------------------------#

sub train_svm{
  my ($model,$trainingsfile,%mapping) = @_;
  my @tsets = ();
  
  #generate datasets for training
  open(my $fh_training,"<",$trainingsfile) or die $!;
  while(my $line = <$fh_training>){
    next if($line =~ /^\s*$/);
    my @info    = split(/,/,$line);
    my $dataset = Algorithm::SVM::DataSet->new(
                       Label => $mapping{0}->{$info[0]},
                       Data  => [
                          map{$mapping{$_}->{$info[$_]}}(1..5)
                                ]);
    push(@tsets,$dataset);
  }
  close $fh_training;
  
  my $svm = Algorithm::SVM->new(Type   => 'C-SVC',
                                Kernel => 'radial',
                                );
                                
  $svm->train(@tsets);
  # Perform cross validation on the training set.
  my $accuracy = $svm->validate(5);
  
  # Save the model to a file.
  $svm->save($model);
}# train_svm

sub predict{
  my ($model,$predictionsfile,%mapping) = @_;
  
  my $svm = Algorithm::SVM->new();
  $svm->load($model);
  
  open(my $fh_predict,"<",$predictionsfile) or die $!;
  while(my $line = <$fh_predict>){
    chomp $line;      
    next if($line =~ /^\s*$/);
    my @info    = split(/,/,$line);
    my $dataset = Algorithm::SVM::DataSet->new(
                       Label => $mapping{0}->{$info[0]},
                       Data  => [
                          map{$mapping{$_}->{$info[$_]}}(1..5)
                                ]);
    my $result = $svm->predict($dataset);
    print sprintf("%-15s",$info[-1]),": ",$result,"\n";
  }
  close $fh_predict;
}# predict