#!/usr/bin/perl

use strict;
use warnings;
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use DBI;

use lib qw(./lib);
use SQL::Abstract::Limit;

my $cgi = CGI->new;
print $cgi->header;

my %params = $cgi->Vars;

##
# der nachfolgende Code ist relevant fr SQL::Abstract

my $sal   = SQL::Abstract::Limit->new( limit_dialect => 'LimitXY' );
my $where;

$where = {
     $params{wherecol} => { $params{whereop} => $params{whereval} },
} if $params{whereval};

my $limit = defined $params{limitval} ? $params{limitval} : undef;

my ($sql,@binds) = $sal->select(
  'testtabelle', [$cgi->param('columns')], $where, 'col1', $limit
);

# der relevante Code ist zu Ende
##

my $dbh = DBI->connect( "DBI:mysql:xxx:xxx","xxx","xxx" ) or die $DBI::errstr;
my $sth = $dbh->prepare( $sql ) or die $dbh->errstr;
$sth->execute( @binds )         or die $dbh->errstr;

print "<table>";
while( my @row = $sth->fetchrow_array ){
   print "<tr>", 
         map{ "<td>$_</td>" }@row,
         "</tr>";
}
print "</table>";