#!/usr/bin/perl

use warnings;
use strict;

my @slots = qw[SCALAR ARRAY HASH CODE IO FORMAT];
my $stash = shift || 'main::';

$stash = 'main::' if $stash eq '::';
$stash .= '::' unless $stash =~ /::$/;

my $recflg = shift;
show_globs($stash,$recflg);

sub show_globs {
  my ($stash,$recflg,$index) = @_;
  $index ||= 0;
  no strict 'refs';
  foreach my $glob (values %{$stash}) {
    my $name = *{$glob}{NAME};
    next if $stash eq 'main::' && $name eq 'main::';
    my $fullname = $stash . $name;
    foreach my $slot (@slots) {
      my $text = ' ' x $index . '*' . $fullname . "{$slot}\n";
      if ($slot eq 'SCALAR') {
        print $text if defined ${$glob};
      }
      else {
        print $text if defined *{$glob}{$slot};
      }
    }
    show_globs($fullname,1,$index+1) if $name =~ /::$/ && $recflg;
  }
}