#include <stdio.h>

void test_value(int val, int *is_neg,
                int *is_odd, int *is_pow2)
{
  *is_neg  = val < 0;
  *is_odd  = val % 2 != 0;
  *is_pow2 = *is_neg
             ? 0 : !(val & (val - 1));
}

int main(void)
{
  int val[] = { -13, 27, 1024 };
  unsigned i;
  unsigned n = sizeof val/sizeof val[0];

  for (i = 0; i < n; i++)
  {
    int neg, odd, pow2;

    test_value(val[i], &neg, &odd, &pow2);

    printf(
      "%+8d : %s, %s, %sa power of 2\n",
       val[i],
              neg ? "negative" : "positive",
                  odd ? "odd" : "even",
                      pow2 ? "" : "not ");
  }

  return 0;
}