#!/usr/bin/perl

use strict;
use warnings;

sub test_value
{
  my($val, $is_neg, $is_odd, $is_pow2) = @_;

  $$is_neg  = $val < 0;
  $$is_odd  = $val % 2 != 0;
  $$is_pow2 = $$is_neg
              ? 0 : !($val & ($val - 1));
}

my @val = ( -13, 27, 1024 );

for my $v (@val) {
  my($neg, $odd, $pow2);

  test_value($v, \$neg, \$odd, \$pow2);

  printf "%+8d : %s, %s, %sa power of 2\n",
         $v,
         $neg ? "negative" : "positive",
         $odd ? "odd" : "even",
         $pow2 ? "" : "not ";
}