#!/usr/bin/perl

use strict;
use warnings;
use CGI;
use CGI::IDS;

my $cgi = new CGI;

my $ids = new CGI::IDS(
  whitelist_file  => '/foo/bar/ids/param_whitelist.xml',
  scan_keys       => 0,
  disable_filters => [58,59,60], # PHP-related filters
);

my %params = $cgi->Vars;
my $impact = $ids->detect_attacks( request => \%params );

if ($impact > 0) {
  # Logging in Datenbank und/oder File
}
if ($impact > 35) {
  # E-Mail an Administrator
}
if ($impact > 100) {
  # SMS an Administrator
  # User ausloggen
}

my $attacks = $ids->get_attacks();

foreach my $attack (@$attacks) {
  $attack->{time_ms}         # Dauer des Checks in ms
  $attack->{key}             # Parameter Key aus Request
  $attack->{key_converted}   # Parameter Key nach Converter, falls scan_keys=1
  $attack->{value}           # Parameter Wert aus Request
  $attack->{value_converted} # Parameter Wert nach Converter
  $attack->{impact}          # Impact der Attacke
  
  # IDs der matchenden Filterregeln
  join(",", @{$attack->{matched_filters}})
  
  # Dokumentations-Strings der matchenden Filterregeln
  join("\n\t", 
       map {"$_: " . 
            $ids->get_rule_description(rule_id => $_)} 
          @{$attack->{matched_filters}}
  )
  
  # Tags der matchenden Filterregeln (z.B. SQLI, CSRF, XSS etc.)
  join(",", @{$attack->{matched_tags}})
}