package MySchema::User;

use strict;
use warnings;
use base qw(DBIx::Class);

__PACKAGE__->load_components( qw/Core/ );
__PACKAGE__->table( 'User' );
__PACKAGE__->add_columns( qw/id username/ );
__PACKAGE__->set_primary_key( 'id' );

__PACKAGE__->has_many(
  'user_rolle' => 'MySchema::UserRole',
  { 'foreign.user_id' => 'self.id' }
);

__PACKAGE__->many_to_many( 'roles' => 'user_rolle', 'role' );

__PACKAGE__->resultset_class(
    'MySchema::ResultSet::UserInfoRS'
);

1;