package MySchema::UserRole;

use strict;
use warnings;
use base qw(DBIx::Class);

__PACKAGE__->load_components( qw/Core/ );
__PACKAGE__->table( 'UserRole' );
__PACKAGE__->add_columns( qw/user_id role_id/ );
__PACKAGE__->set_primary_key( qw/user_id role_id/ );

__PACKAGE__->belongs_to(
  'user' => 'MySchema::User',
  { 'foreign.id' => 'self.user_id' }
);
__PACKAGE__->belongs_to(
  'role' => 'MySchema::Role',
  { 'foreign.id' => 'self.role_id' }
);

1;