package DB::Profiler;

use strict;
use warnings;
use DBIx::Class::Storage::Statistics;

our @ISA = qw(DBIx::Class::Storage::Statistics);
use Time::HiRes qw(time);

my $start;

sub query_start {
    $start = time;
}

sub query_end {
    my $diff = time - $start;
    my ($self,$sql,@params) = @_;
    
    print "Statement: $sql\n",
          "Parameters: @params\n",
          "Execution time: $diff\n\n";
    $start = undef;
}

1;