#!/usr/bin/perl
use strict;
use warnings;
use MySchema;

my $schema = MySchema->connect( 'DBI:SQLite:MasterClass' );

my ($r) = $schema->resultset('PrintAbo')->all;

print $r->username, "\n";

my @old_persons = $schema->resultset( 'ByAge' )->search(
    {},
    {
        bind => [ 79 ],
    }
);

print "These persons are older than 79 years:\n";
print sprintf( "  %s: %d\n", $_->username, $_->age ) for @old_persons;