#!/usr/bin/perl

use strict;
use warnings;
use Sub::Pipe;

time | joint( sub { nice_date(@_) } ) | joint(\&print_date );

sub nice_date {
    my ($timestamp) = @_;
    
    my ($d,$m,$y) = (localtime $timestamp)[3..5];
    return sprintf "%02d.%02d.%04d", $d, $m+1, $y+1900;
}

sub print_date {
    my ($date) = @_;
    print "Datum: $date";
}