#!/usr/bin/perl

use strict;
use warnings;
use Tree::Family;

my $tree = Tree::Family->new(filename => './tree.dmp');

my $person = Tree::Family::Person->new(name => 'Fred');
my $nother = Tree::Family::Person->new(name => 'Wilma');

$person->spouse($nother);

$tree->add_person($person);
$tree->add_person($nother);

for ($tree->people) {
    print $_->name;
}

my $dot_file = $tree->as_dot;