#!/usr/bin/perl

use strict;
use warnings;
use Local::DBIC_Schema;

my $schema = Local::DBIC_Schema->connect( 'DBI:SQLite:board' );
$schema->storage->debug(1);

# Tabelle 'T' enthlt die Informationen ber die Threads und hat
# eine has_many-Relation mit dem Namen Ps auf die Posts-Tabelle
my @threads = $schema->resultset( 'T' )->search(
    undef,
    { 
        join      => 'Ps',
        '+select' => \'MAX(Ps.timestamp) as tmax',
        '+as'     => 'timestamp',
        order_by  => 'tmax DESC',
        group_by  => 'testid',
    }
);

for ( @threads ) {
    print $_->name, " -> ", $_->get_column( 'timestamp' ),"\n" ;
}