package GPS::Controller::REST;

use strict;
use warnings;

use base 'Catalyst::Controller::REST';

sub point : Local : ActionClass('REST') { }

# Answer GET requests to "thing"
sub point_GET {
    my ( $self, $c ) = @_;
    
    my @points = $c->model('Point')->search->all;
    
    my @found;
    for my $point ( @points ){
        push @found, {
            Name => $point->Name,
            Lat  => $point->Lat,
            Lon  => $point->Lon,
        };
    }

    $c->stash->{template} = 'rest/point';
    $c->stash->{points}   = \@found;
}

# Answer PUT requests to "thing"
sub point_PUT { 
    my ( $self, $c ) = @_;
    
    # insert into db
    my $point = $c->model( 'Point' )->create({
        Name => $c->req->data->{name},
        Lat  => $c->req->data->{lat},
        Lon  => $c->req->data->{lon},
    });
    $point->update;
    
    $self->status_created(
       $c,
       location => $c->req->uri->as_string,
       entity => $c->req->data,
    );
}

1;
__END__

=head2 Foo::Controller::REST

In dem Beispiel mit CGI.pm sieht man, dass fr eine komplexe REST-API viel Arbeit notwendig ist: Man muss sich ber akzeptierte Formate Gedanken machen und wie man die Daten fr den Client aufbereitet. Wenn man Catalyst verwendet kann man sich das Leben recht einfach machen, da man dann C<Catalyst::Controller::REST> verwenden kann. Das Modul hat Voreinstellungen fr die verschiedenen Formate.

Der bersichtlichket halber verwende ich fr jede Entitt, die per REST-API abgebildet werden soll, eine extra Klasse. Die eigene Klasse muss von C<Catalyst::Controller::REST> erben. Fr die Entitt - hier "point" - wird eine Methode ohne Ihnhalt angelegt. Diese muss die "ActionClass" mit dem Parameter 'REST' haben.

Mit ActionClass kann man angeben, welche C<Catalyst::Action::*>-Klasse (hier: C<C::A::REST>) verwendet werden soll. Das soll hier aber nicht Thema sein.

Als nchstes muss man dann noch fr die einzelnen HTTP-Request-Arten eine Methode schreiben, wobei das Format so aussieht: C<< <Entitaet>_<Request> >>, also z.B. C<point_GET>. Damit wird jeder I<GET>-Request auf I<point> von der Methode C<point_GET> abgearbeitet.

Das Modul parst auch gleich den Inhalt - je nach C<Content-type> - und ermglicht den Zugriff auf die geparsten Daten ber C<< $c->req->data >>.

Zum Schluss muss man dann nur noch den Status setzen und die Entitt bergeben. Die Serialisierung der Daten bernimmt dann wieder das Modul. In den Codebeispielen dieser Ausgabe ist die komplette Beispielanwendung zu finden (C<Catalyst>, C<DBIx::Class> und das hier beschriebene Modul werden bentigt).