package GPS::Controller::Root;

use strict;
use warnings;
use parent 'Catalyst::Controller';

#
# Sets the actions in this controller to be registered with no prefix
# so they function identically to actions created in MyApp.pm
#
__PACKAGE__->config->{namespace} = '';

=head1 NAME

GPS::Controller::Root - Root Controller for GPS

=head1 DESCRIPTION

[enter your description here]

=head1 METHODS

=cut

=head2 index

=cut

sub index :Path :Args(0) {
    my ( $self, $c ) = @_;
    
    my @points = $c->model('Point')->search->all;
    
    my @found;
    for my $point ( @points ){
        push @found, {
            Name => $point->Name,
            Lat  => $point->Lat,
            Lon  => $point->Lon,
        };
    }

    # Hello World
    $c->stash->{template} = 'root/templates/overview.tmpl';
    $c->stash->{DATA}     = \@found;
}

sub default :Path {
    my ( $self, $c ) = @_;
    $c->response->body( 'Page not found' );
    $c->response->status(404);
}

=head2 end

Attempt to render a view, if needed.

=cut

sub end : ActionClass('RenderView') {}

=head1 AUTHOR

Catalyst developer

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
