use warnings;
use strict;

package Hash;

use Hash::Util;

sub new {
    my $class = shift;

    my $self = bless {},$class;
    $self->set(@_);

    return $self;
}

sub set {
    my $self = shift;

    while (@_) {
        my $key = shift;
        $self->{$key} = shift;
    }

    return;
}

sub lockKeys {
    my $self = shift;
    Hash::Util::lock_keys(%$self);
    return;
}

sub unlockKeys {
    my $self = shift;
    Hash::Util::unlock_keys(%$self);
    return;
}

package Person;
use base qw/Hash/;

sub anrede {
    my $self = shift;

    if ($self->{'geschlecht'} eq 'w') {
        return "Sehr geehrte Frau $self->{'nachname'}";
    }
    return "Sehr geehrter Herr $self->{'nachname'}";
}

package PersonHash;
use base qw/Person/;

sub new {
    my $class = shift;

    my $self = $class->SUPER::new;
    $self->set(
        vorname=>undef,
        nachname=>undef,
        geschlecht=>undef,
    );
    $self->set(@_);

    return $self;
}

package KundeHash;
use base qw/PersonHash/;

sub new {
    my $class = shift;

    my $self = $class->SUPER::new;
    $self->set(
        kundenNr=>undef,
    );
    $self->set(@_);

    return $self;
}

package PersonRestricted;
use base qw/Person/;

sub new {
    my $class = shift;

    my $self = $class->SUPER::new;
    $self->set(
        vorname=>undef,
        nachname=>undef,
        geschlecht=>undef,
    );
    $self->lockKeys;
    $self->set(@_);

    return $self;
}

package KundeRestricted;
use base qw/PersonRestricted/;

sub new {
    my $class = shift;

    my $self = $class->SUPER::new;
    $self->unlockKeys;
    $self->set(
        kundenNr=>undef,
    );
    $self->lockKeys;
    $self->set(@_);

    return $self;
}

1;

# eof
