#!/usr/bin/perl

use warnings;
use strict;

use Classes;
use Benchmark qw(cmpthese);

print "Objekt instantiieren:\n\n";

cmpthese(-2,{
        'Hash' => sub {
            KundeHash->new(
                kundenNr=>1,
                vorname=>'Elli',
                nachname=>'Pirelli',
                geschlecht=>'w',
            );
        },
        'RestrHash' => sub {
            KundeRestricted->new(
                kundenNr=>1,
                vorname=>'Elli',
                nachname=>'Pirelli',
                geschlecht=>'w',
            );
        },
    }
);

print "\nAttribut lesen:\n\n";

my $kunH = KundeHash->new(
    kundenNr=>1,
    vorname=>'Elli',
    nachname=>'Pirelli',
    geschlecht=>'w',
);

my $kunR = KundeRestricted->new(
    kundenNr=>1,
    vorname=>'Elli',
    nachname=>'Pirelli',
    geschlecht=>'w',
);

cmpthese(-3,{
        'Hash' => sub {
            $kunH->{'nachname'};
        },
        'RestrHash' => sub {
            $kunR->{'nachname'};
        },
    }
);

print "\nAttribut schreiben:\n\n";

cmpthese(-3,{
        'Hash' => sub {
            $kunH->{'geschlecht'} = 'w';
        },
        'RestrHash' => sub {
            $kunR->{'geschlecht'} = 'w';
        },
    }
);

__END__
