#!/usr/bin/perl

use strict;
use warnings;

use Text::Diff3;

my @text1 = qw(Zeile1 Zeile2 Zeile3);
my @text2 = qw(Zeile1 Zeile2.0 Zeile3.0);
my @text3 = qw(Zeile1.0 Zeile2.0 Zeile3);

my $f = Text::Diff3::Factory->new;
my $mytext   = $f->create_text( \@text1 );
my $original = $f->create_text( \@text2 );
my $yourtext = $f->create_text( \@text3 );

my $p = $f->create_diff3;
my $diff3 = $p->diff3($mytext, $original, $yourtext);

$diff3->each(sub{
    my($r) = @_;
    print $r->as_string, "\n";
    print $mytext->as_string_range($r->range0);
    print $original->as_string_range($r->range1);
    print $yourtext->as_string_range($r->range2);
});