package CGIScript;

use strict;
use warnings;
use Devel::Declare;

our ($declarator, $offset);

sub import {
    my ( $class ) = @_;
    
    my $caller    = caller;
    
    Devel::Declare->setup_for(
        $caller,
        {
            cgi_script => { const => \&parser },
        }
    );
}

sub parser {
    local ( $declarator, $offset ) = @_;
    
    strip_name();
    my $inject = 'require CGI; my $cgi = CGI->new';
    inject($inject);
    
    print Devel::Declare::get_linestr();

}

sub skipspace {
    $offset += Devel::Declare::toke_skipspace($offset);
}

sub strip_name {
    skipspace();
    if (my $len = Devel::Declare::toke_scan_word($offset, 1)) {
      my $linestr = Devel::Declare::get_linestr();
      my $name = substr($linestr, $offset, $len);
      substr($linestr, $offset, $len) = '';
      Devel::Declare::set_linestr($linestr);
      return $name;
    }
    return;
}

sub inject {
    my $inject = shift;
    my $linestr = Devel::Declare::get_linestr;
    substr($linestr, $offset, 0) = $inject;
    Devel::Declare::set_linestr($linestr);
}

1;