package CheckContext;

use strict;
use warnings;
use Devel::Declare;

our ($declarator, $offset);

sub import {
    my ( $class ) = @_;
    
    my $caller    = caller;
    
    Devel::Declare->setup_for(
        $caller,
        {
            void => { const => \&parser },
        }
    );
    
    no strict 'refs';
    *{ $caller . '::void' } = sub (&) {};
}

sub parser {
    local ( $declarator, $offset ) = @_;
    
    skip_declarator();          # step past 'void'
    my $name   = strip_name();  # strip out the name 'test', if present
    my $inject = inject_code( $declarator, $name );

    inject_if_block($inject);
    
    if (defined $name) {
        $name = join('::', Devel::Declare::get_curstash_name(), $name)
          unless ($name =~ /::/);
        shadow(sub (&) { no strict 'refs'; *{$name} = shift; });
    } else {
        shadow(sub (&) { shift });
    }
}

sub skip_declarator {
    $offset += Devel::Declare::toke_move_past_token($offset);
}

sub skipspace {
    $offset += Devel::Declare::toke_skipspace($offset);
}

sub shadow {
    my $pack = Devel::Declare::get_curstash_name;
    Devel::Declare::shadow_sub("${pack}::${declarator}", $_[0]);
}

sub strip_name {
    skipspace();
    if (my $len = Devel::Declare::toke_scan_word($offset, 1)) {
      my $linestr = Devel::Declare::get_linestr();
      my $name = substr($linestr, $offset, $len);
      substr($linestr, $offset, $len) = '';
      Devel::Declare::set_linestr($linestr);
      return $name;
    }
    return;
}

sub inject_if_block {
    my $inject = shift;
    skipspace();
    my $linestr = Devel::Declare::get_linestr;
    if (substr($linestr, $offset, 1) eq '{') {
        substr($linestr, $offset+1, 0) = $inject;
        Devel::Declare::set_linestr($linestr);
    }
}

sub inject_code {
    my ($decl,$name) = @_;
    
    my %subs = (
        void   => qq~if( defined wantarray ) { die "sub $name must be called in void context"; }~,
    );
    
    my $code = '';
    $code = $subs{$decl} if exists $subs{$decl};
    
    $code;
}

1;