package CheckContextSimple;

use strict;
use warnings;
use parent 'Devel::Declare::MethodInstaller::Simple';

sub import {
    my ( $class ) = @_;
    
    my $caller    = caller;
        
    $class->install_methodhandler(
        into            => $caller,
        name            => 'void',
    );
}
sub code_for {
    my ($self,$name) = @_;
    
    my $decl = $self->declarator;
    
    my %subs = (
        void   => \&voidsub,
    );
    
    if( defined $name ) {
        my $pkg = $self->get_curstash_name;
        $name   = join( '::', $pkg, $name ) 
            if index( $name, '::' ) == -1;
        return sub (&) {
            my $code = shift;
            my $sub  = $subs{$decl}->($name,$code,@_);
            no strict 'refs';
            *{$name} = subname $name => $sub;
            return;
        }
    }
    else {
        return sub (&) { shift };
    }
}

sub voidsub {
    my ($name,$code) = (shift,shift);
    
    my $sub  = sub {
        if( defined wantarray ) {
            die "sub $name must be called in void context";
        }              
                
        $code->(@_);
    };
}

1;