#!/usr/bin/perl
use strict;
use warnings;
use DBI;
use Encode; 		# importiert decode_utf8
use HTML::Display;  	# importiert display()
use CGI;

my $table = retrieve();

my $html = create_html( $table );

display( html => $html ); # legt automatisch eine temp-Datei an

sub create_html {
	my $table = shift @_;
	my $cgi =  new CGI;
	my $content;
	$content = $cgi->start_html( 'Database Report' );
	$content .= $cgi->start_table( { -border => 1 } );

	foreach my $row (@$table) {
		$content .= $cgi->Tr( { -align => 'left', -valign => 'top' },
                                      $cgi->td( $row )
                                  );
	}

	$content .= $cgi->end_table();
	$content .= $cgi->end_html();

	$content = decode_utf8( $content ); 
	return $content;
}

sub retrieve {

	my $dbh = DBI->connect( "dbi:SQLite:dbname=Adressen.db", "", "",
						{ RaiseError => 1 } );

	my $sql = qq~select customer_id,vorname,nachname from customer~;

	my $sth = $dbh->prepare( $sql );
	$sth->execute();

	my $tbl_ary_ref = $sth->fetchall_arrayref;

	$sth->finish();
	undef $sth;
	$dbh->disconnect();

	return wantarray ? @$tbl_ary_ref : $tbl_ary_ref;
}