#!/usr/bin/perl

use strict;
use warnings;

{
    package MyTest;

    use Moose;
    use Scalar::Util qw( blessed );
    
    sub test {
        my ($self, $foo) = @_;
        
        unless ( blessed $foo and $foo->isa( 'Magazin' ) ) {
            die '$foo is not of type "Magazin"';
        }
      
        print "Ausgabe: ", $foo->ausgabe, "\n",
              "Seiten: ",  $foo->seiten, "\n";
    }
}

{
    package Magazin;
    
    use Moose;
    has ausgabe => ( is => 'ro' );
    has seiten  => ( is => 'ro' );
}

my $magazin = Magazin->new( ausgabe => 12, seiten => 68 );
my $test    = MyTest->new;

$test->test( $magazin );
$test->test( 'hallo' );