#!/usr/bin/perl

use strict;
use warnings;
use XML::LibXSLT;
use XML::LibXML;

my $xml_file  = 'test.xml';
my $xslt_file = 'time.xsl';

my $libxml  = XML::LibXML->new();
my $libxslt = XML::LibXSLT->new();

XML::LibXSLT->register_function("urn:foo", "printtime", sub { scalar localtime });

my $parsed_xml = $libxml->parse_file( $xml_file );
my $stylesheet = $libxslt->parse_stylesheet_file( $xslt_file );
my $result     = $stylesheet->transform( $parsed_xml );
print $stylesheet->output_string( $result );