#!/usr/bin/perl -l

use strict;
use warnings;
use XML::LibXML;

my $xml     = do{ local $/; <DATA> };
my $parser  = XML::LibXML->new;
my $doc     = $parser->parse_string( $xml );

my $root    = $doc->getDocumentElement;
my @authors = $root->findvalue( 'autoren/name' );

for my $author ( @authors ){
    print "Autor: ", $author;
}

__DATA__
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<foo ausgabeId="12">
  <inhalte>
    <artikel>XML und Perl</artikel>
    <artikel>Tips und Tricks</artikel>
  </inhalte>
  <autoren>
    <name>Renee Baecker</name>
  </autoren>
</foo>