#!/usr/bin/perl -l

use strict;
use warnings;
use XML::Twig;

my $xml    = do{ local $/; <DATA> };
my @authors;

my $parser = XML::Twig->new(
    twig_handlers => {
        autoren => sub{ filter_authors( \@authors, @_ ) },
    },
);
my $tree   = $parser->parse( $xml );

for my $author ( @authors ){
    print "Autor: ", $author;
}

sub filter_authors {
    my ($arref, $twig, $author) = @_;
    
    my @authors      = $author->children;
    for my $single_author ( @authors ){
        push @$arref, $single_author->text;
    }
}

__DATA__
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<foo ausgabeId="12">
  <inhalte>
    <artikel>XML und Perl</artikel>
    <artikel>Tips und Tricks</artikel>
  </inhalte>
  <autoren>
    <name>Renee Baecker</name>
  </autoren>
</foo>