#!/usr/bin/perl -l

use strict;
use warnings;
use XML::Twig;

my $xml    = do{ local $/; <DATA> };
my $parser = XML::Twig->new;
my $tree   = $parser->parse( $xml );

my $root         = $tree->root;
my $authors_node = $root->first_child( 'autoren' );
my @authors      = $authors_node->children;

for my $author ( @authors ){
    print "Autor: ", $author->text
}

__DATA__
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<foo ausgabeId="12">
  <inhalte>
    <artikel>XML und Perl</artikel>
    <artikel>Tips und Tricks</artikel>
  </inhalte>
  <autoren>
    <name>Renee Baecker</name>
  </autoren>
</foo>