#!/usr/bin/perl

use strict;
use warnings;
use XML::LibXML;

my $dtd_file = 'test.dtd';
my $xml_file = 'test_dtd.xml';

my $schema = XML::LibXML::Dtd->new( "", $dtd_file );
my $parser = XML::LibXML->new;
$parser->keep_blanks(0);

my $tree   = $parser->parse_file( $xml_file );

eval{
    print $tree->validate( $schema );
    1;
} or die "Can't validate $xml_file: $@";