#!/usr/bin/perl

use strict;
use warnings;

use HTML::Filter::Callbacks;

my $html = do { local (@ARGV,$/) = 'test.html'; <> };

my $filter = HTML::Filter::Callbacks->new;
$filter->add_callbacks(
  'a' => {
    start => sub {
      shift->replace_attr(href => sub {
          my ($url) = @_;
          $url =~ s/alte-domain\.de/neue-domain.de/;
          $url;
      })
    },
  },
);
my $new_html = $filter->process($html);
print $new_html;
