#!/usr/bin/perl

use strict;
use warnings;
use Web::Scraper;
use Date::ICal;
use Data::ICal;
use Data::ICal::Entry::Event;
use LWP::Simple ();
use Data::Dumper;
use Time::Local;
use Encode;
use Devel::Peek;
use Scalar::Util;

my $url     = 'http://www.perl-workshop.de/de/2009/zeitplan.html';
my $content = LWP::Simple::get( $url );
my @days    = qw(25.02.2009 26.02.2009 27.02.2009);

my $scraper = scraper {
   process 'div[class="zeitplan"]', 'tage' => scraper {
       process 'table', 'vortraege[]' => scraper {
           process 'td', 'eintraege[]' => 'TEXT';
       };
   };
   
   result 'tage';
};

my $all_days = $scraper->scrape( $content );
$all_days = $all_days->{vortraege};

#die Dumper $all_days;

my $ical_all = Data::ICal->new;

for my $i ( 0 .. $#$all_days ){
    my $date = $days[$i];
    my $day  = $all_days->[$i];
    
    my $days_ical = Data::ICal->new;
    
    my (undef,$entries) = %$day;
    while( @$entries ){
        my $time      = shift @$entries;
        my $duration  = shift @$entries;
        my $presenter = shift @$entries;
        my $title     = shift @$entries;
        
        next if $presenter =~ /--/ and $presenter !~ /-- Social Event/;
        
        if( $presenter =~ /Social Event/ ){
            $duration  = 180;
            $title     = "Social Event";
            $presenter = "Alle";
        }
        
        $presenter = encode( 'utf-8', $presenter ) if $presenter =~ /Christoffel/;
        
        my $dtstart =  _get_epoche( $date, $time );
        $duration   =~ s/\s*min\s*(?:\(Tutorial\))?//;
        $duration   = 30 if $duration =~ /BOF/;
        
        my $event   = Data::ICal::Entry::Event->new;
        $event->add_properties(
            summary => sprintf( "%s: %s", $presenter, $title ),
            dtstart => Date::ICal->new( epoch => $dtstart )->ical,
            dtend   => Date::ICal->new( epoch => $dtstart + ( $duration * 60 ) )->ical,
        );
        
        $days_ical->add_entry( $event );
        $ical_all->add_entry( $event );
    }

    my $filename = _get_filename( $date );
    open my $fh, '>', $filename or die $filename,":", $!;
    print {$fh} $days_ical->as_string;
    close $fh;
}

open my $fh, '>', 'gpw2009.ics' or die $!;
print {$fh} $ical_all->as_string;
close $fh;

sub _get_epoche {
    my ($date,$time) = @_;
    
    my @date_info = split /\./, $date;
    my @time_info = split /:/, $time;
    my $epoche    = timelocal( 
        0, reverse( @time_info ),
        $date_info[0], $date_info[1]-1, $date_info[2]-1900
    );
    
    $epoche;
}

sub _get_filename{
    my ($date) = @_;
    
    my @info = split /\./, $date;
    join "", reverse '.ics', @info,'gpw09_';
}