#!/usr/bin/perl 
#-------------------------------------------------------------------- 
# Geo-Koordinaten ermitteln 
# By Max Kossatz, 2009 
# http://wissenbelastet.com 
# Lizenz: Creative Commons BY-NC 
# http://creativecommons.org/licenses/by-nc/3.0/at/ 
#-------------------------------------------------------------------- 
 
# Fr die Datenbank-Anbindung wird in diesem Beispiel MySQL 
# verwendet, kann aber auch jede andere Datenbank sein. 
use DBI; 
 
# Die Geokoordinaten werden mittels Googles Geo-Coder ermittelt. 
# Hierzu wird ein Google Maps-API Key bentigt, nhere Infos siehe 
# hier: http://code.google.com/intl/de/apis/maps/signup.html 
use Geo::Coder::Google; 
my $geo = Geo::Coder::Google->new(
    apikey   =>'GOOGLE_MAPS_API_KEY', 
    language =>'de',
); 

# Verbindung zur Datenbank herstellen. 
# DATENBANK, USERNAME und PASSWORT entsprechend anpassen. 
my $dsn = "DBI:mysql:database=DATENBANK;mysql_enable_utf8=1"; 
my $dbh = DBI->connect($dsn,"USERNAME","PASSWORT"); 

# Ungebufferte Ausgabe zum Mitloggen. 
$|=1; 

# Da eine Haltestelle von mehreren Linien angefahren wird ist in Wien nur die 
# Haltnummer als eindeutiges Kriterium verwendbar. 
$db = $dbh->prepare(
  "SELECT distinct haltnummer from oeffi where plz=0 order by haltestelle asc"
); 

$db->execute; 

while($haltnummer=$db->fetchrow_array) { 

# Aufgrund der Haltnummer den Stationsnamen aus der Datenbank holen. 
    $db1 = $dbh->prepare(
      "select haltestelle from oeffi where haltnummer=$haltnummer limit 0,1"
    ); 

    $db1->execute; 

    $haltestelle = $db1->fetchrow_array; 

# Diese Haltestelle an den Google Geocoder bergeben. Als "Trick" wird vor den 
# Haltestellennamen "Haltestelle " und nachher ", Wien" geschrieben, mit den 
# Wiener Daten hat dies sehr gut funktioniert. 
    my $location = $geo->geocode( 
        location => 'Haltestelle '.$haltestelle.", Wien"
    );
    $longi   = $location->{'Point'}->{'coordinates'}->[0]; 
    $lati    = $location->{'Point'}->{'coordinates'}->[1]; 
    $plz     = ""; 
    $address = $location->{'address'}; 
   
# Um die Daten berprfen zu knnen wird die Postleitzahl der ermittelten Geo- 
# Position ermittelt, falls diese nicht vorhanden ist wird die Geo-Abfrage 
# nochmals ohne "Haltestelle " durchgefhrt. 
    $address =~ /(\d\d\d\d) Wien/; 
    $plz = $1; 
    if (!$plz) { 
        $location = $geo->geocode( location => $haltestelle.", Wien"); 
        $longi    = $location->{'Point'}->{'coordinates'}->[0]; 
        $lati     = $location->{'Point'}->{'coordinates'}->[1]; 
        $plz      = ""; 
        $address  = $location->{'address'}; 
        $address  =~ /(\d\d\d\d) Wien/; 
        $plz      = $1; 
    } 
   
# Die Postleitzahl wird, damit man dann einfacher die Ergebnisse berprfen 
# kann, in er Datenbank mit abgespeichert. 
    if (!$plz) { $plz = 0; } 
    $dbh->do(
        "update oeffi set longi=$longi, lati=$lati, plz=$plz where haltnummer=$haltnummer"
    ); 
} 