#!/usr/bin/perl 
#-------------------------------------------------------------------- 
# Erstellung der Grafiken mit der eingeblendeten Uhrzeit 
# By Max Kossatz, 2009 
# http://wissenbelastet.com 
# Lizenz: Creative Commons BY-NC 
# http://creativecommons.org/licenses/by-nc/3.0/at/ 
#-------------------------------------------------------------------- 

# Fr die Datenbank-Anbindung wird in diesem Beispiel MySQL 
# verwendet, kann aber auch jede andere Datenbank sein. 
use DBI; 

# Perl Modul fr Image Magick, siehe http://www.imagemagick.org/ 
use Image::Magick; 

# Verbindung zur Datenbank herstellen. 
# DATENBANK, USERNAME und PASSWORT entsprechend anpassen. 
my $dsn="DBI:mysql:database=DATENBANK;mysql_enable_utf8=1"; 
my $dbh=DBI->connect($dsn,"USERNAME","PASSWORT"); 

# Ungebufferte Ausgabe zum Mitloggen. 
$|=1; 

# Folder in dem die fertigen Grafiken gespeichert werden sollen. 
$folder="uhrzeit/"; 

# Nummer der Grafik innerhalb der Sequenz, beginnend mit 1. 
$filenummer=1; 

# Die Uhrzeiten aus der Datenbank holen. 
my $sth= $dbh->prepare(
  "select distinct uhrzeit from oeffi order by uhrzeit asc"
); 
$sth->execute; 
$uhrzeit=$sth->fetchrow_array; 

# Da die erste Uhrzeit "0" ist, dient $a dazu um nicht die while- 
# Anweisung sofort abzubrechen. 
$a=1; 

while($uhrzeit=$sth->fetchrow_array || $a) { 

# Uhrzeit "0" geschafft, $a auf "0" setzen. 
    $a=0; 

# Grafik erstellen, Hintergrundfarbe Grn um im Videoschnitt-Programm 
# diese Farbe Transparent machen zu knnen. 
    $image=Image::Magick->new; 

    $image->Set(size=>'1115x812'); 
    $image->ReadImage('xc:green'); 

# Umwandlung der Uhrzeit aus der Datenbank in das Format HH:MM. 
    $uhrzeit=sprintf '%04s',$uhrzeit; 
    $uhrzeit=~/(\d\d)(\d\d)/; 
    $puhr=$1.":".$2; 

# Uhrzeit in die Grafik eintragen. 
    $image->Annotate(
        text      => $puhr,
        x         => 520,
        y         => 40,
        pointsize => 30,
        fill      => 'black', 
        stroke    => '#444444',
    ); 

# Grafik abspeichern, Filenummer erhhen. 
    $image->Write('png:'.$folder.$filenummer.'.png'); 
    $filenummer++; 
}