#!/usr/bin/perl 
#-------------------------------------------------------------------- 
# Erstellung der Balkengrafik 
# By Max Kossatz, 2009 
# http://wissenbelastet.com 
# Lizenz: Creative Commons BY-NC 
# http://creativecommons.org/licenses/by-nc/3.0/at/ 
#-------------------------------------------------------------------- 
 
# Fr die Datenbank-Anbindung wird in diesem Beispiel MySQL 
# verwendet, kann aber auch jede andere Datenbank sein. 
use DBI; 
 
# Perl Modul fr Image Magick, siehe http://www.imagemagick.org/ 
use Image::Magick; 
 
# Verbindung zur Datenbank herstellen. 
# DATENBANK, USERNAME und PASSWORT entsprechend anpassen. 
my $dsn="DBI:mysql:database=DATENBANK;mysql_enable_utf8=1"; 
my $dbh=DBI->connect($dsn,"USERNAME","PASSWORT"); 
 
# Ungebufferte Ausgabe zum Mitloggen. 
$|=1; 
 
# Folder in dem die fertigen Grafiken gespeichert werden sollen. 
$folder="graphen/"; 
 
# Nummer der Grafik innerhalb der Sequenz, beginnend mit 1. 
$filenummer=1; 
 
# Uhrzeiten aus der Datenbank holen. 
my $sth= $dbh->prepare("select distinct uhrzeit from oeffi order by uhrzeit asc"); 
$sth->execute; 
$uhrzeit=$sth->fetchrow_array; 
 
# Da die erste Uhrzeit "0" ist, dient $a dazu um nicht die while- 
# Anweisung sofort abzubrechen. 
$a=1; 
while($uhrzeit=$sth->fetchrow_array || $a) { 
    if (!$uhrzeit) { $uhrzeit='0000'; } 
 
# Uhrzeit "0" geschafft, $a auf "0" setzen. 
    $a=0; 
 
# Leere Grafik erstellen, Hintergrundfarbe Gelb um diese Farbe im 
# Videoschnittprogramm Transparent machen zu knnen. 
    $image=Image::Magick->new; 
    $image->Set(size=>'1115x812'); 
    $image->ReadImage('xc:yellow'); 
 
# Zuerst die Autobuslinien, die in Wien auf "A" enden und in der Grafik Rot 
# dargestellt werden. 
    $rot = $dbh->prepare(
        "select count(id) from oeffi where uhrzeit=$uhrzeit and linie like '\%A'"
    ); 
    $rot->execute; 
    $rot = $rot->fetchrow_array; 
 
# Der Balken kann maximal 400 Pixel hoch sein und ist 20 Pixel breit. 
    if ($rot>0) { 
 
# Berechnung der Balkenhhe. 
        $rot = 400-int(200/500*$rot); 
 
# Balken zeichnen. 
        $image->Draw(
            stroke    => '#FF0000',
            fill      => '#FF0000', 
            primitive => 'rectangle',
            points    => '100,400 119,'.$rot,
        ); 
    } 
 
# Dann die Straenbahnen, die in Wien nicht auf "A" enden und nicht mit "N" 
# beginnen, werden in der Grafik Blau dargestellt. 
    $blau = $dbh->prepare(
        "select count(id) from oeffi where uhrzeit=$uhrzeit 
             and linie not like '\%A' and linie not like 'N\%'"
    ); 
    $blau->execute; 
    $blau = $blau->fetchrow_array; 
    if ($blau>0) { 
        $blau = 400 - int(200/500*$blau); 
        $image->Draw(
            stroke    => '#0000FF',
            fill      => '#0000FF', 
            primitive => 'rectangle',
            points    => '120,400 139,'.$blau,
        ); 
    } 
 
# Zum Schlu die Nachtautobusse, die in Wien mit "N" beginnen und in der Grafik 
# Grn dargestellt werden. 
    $gruen = $dbh->prepare(
        "select count(id) from oeffi where uhrzeit=$uhrzeit 
            and linie like 'N\%'"
    ); 
    $gruen->execute; 
    $gruen = $gruen->fetchrow_array; 
    if ($gruen>0) { 
        $gruen=400-int(200/500*$gruen); 
        $image->Draw(
            stroke    => '#00FF00',
            fill      => '#00FF00', 
            primitive => 'rectangle',
            points    => '140,400 159,'.$gruen,
        ); 
    }
 
    $image->Write('png:'.$folder.$filenummer.'.png'); 
    $filenummer++; 
}