#!/usr/bin/perl 
#-------------------------------------------------------------------- 
# Berechnung der Punkte auf der Wien-Karte 
# By Max Kossatz, 2009 
# http://wissenbelastet.com 
# Lizenz: Creative Commons BY-NC 
# http://creativecommons.org/licenses/by-nc/3.0/at/ 
#-------------------------------------------------------------------- 
 
# Fr die Datenbank-Anbindung wird in diesem Beispiel MySQL 
# verwendet, kann aber auch jede andere Datenbank sein. 
use DBI; 
 
# Perl Modul fr Image Magick, siehe http://www.imagemagick.org/ 
use Image::Magick; 
 
# Verbindung zur Datenbank herstellen. 
# DATENBANK, USERNAME und PASSWORT entsprechend anpassen. 
my $dsn="DBI:mysql:database=DATENBANK;mysql_enable_utf8=1"; 
my $dbh=DBI->connect($dsn,"USERNAME","PASSWORT"); 
 
# Ungebufferte Ausgabe zum Mitloggen. 
$|=1; 
 
# Folder in dem die fertigen Grafiken gespeichert werden sollen. 
$folder="bilder/"; 
 
# Nummer der Grafik innerhalb der Sequenz, beginnend mit 1. 
$imagenummer=1; 
 
# Diese vier Koordinaten definieren die Ecken des Rechteckes 
# in dem sich die Geo-Koordinaten befinden, um diese entsprechend 
# auf die Hintergrundgrafik umrechnen zu knnen. 
# 
# Diese Koordinaten findet man z. B. auf http://openstreetmap.org 
# Als Beispiel wird Wien verwendet. 
 
# Westlichster Punkt des Rechtecks 
$longimin=16.258322; 
 
# stlichster Punkt des Rechtecks 
$longimax=16.580219; 
 
# Sdlichster Punkt des Rechtecks 
$latimin=48.128469; 
 
# Nrdlichster Punkt des Rechtecks 
$latimax=48.298805; 
 
# Berechnung Breite des Rechtecks 
$longidiff=$longimax-$longimin; 
 
# Berechnung der Hhe des Rechtecks 
$latidiff=$latimax-$latimin; 
 
# Berechnung der Mitte des Rechtecks, wichtig fr das Koordinaten- 
# System 
$longimitte=($longimin+$longimax)/2; 
$latimitte=($latimin+$latimax)/2; 
 
# Die breite der fertigen Grafik 
$breite=1000; 
 
# Das Seitenverhltnis fr die fertige Grafik 
$aspect=4/3; 
 
# Die Hhe der Grafik wird ber das Seitenverhltnis und 
# die Hhe bzw. Breite des Geo-Raums definiert. 
$hoehe=int(($latidiff/($longidiff/$breite))*$aspect); 
 
# Berechnen des Verhltnisses von Breite bzw. Hhe 
# pro dargestelltem Pixel. 
$xpixel=$longidiff/$breite; 
$ypixel=$latidiff/$hoehe; 
 
# Damit die ussersten Haltestellen nicht abgeschnitten werden, 
# wird der Bildbereich um diesen Faktor vergrert, sozusagen 
# ein "Rahmen" um die Darstellungsflche. 
$size=1.1; 

# Berechnung der neuen Breite und Hhe der Grafik. 
$neue_breite=int($breite*$size); 
$neue_hoehe=int($hoehe*$size); 
 
# um zu wissen wann eine neue Uhrzeit (=neue Grafik) anfngt. 
$uhrzeit_alt=0; 
 
# ImageMagick Image erstellen mit der berechneten Breite und Hhe. 
$image=Image::Magick->new; 
$image->Set(size=>$neue_breite.'x'.$neue_hoehe); 
 
# Image ist Schwarz mit Transparenzfarbe Schwarz. 
$image->ReadImage('xc:black'); 
$image->Transparent('black'); 
 
# Um den Nachzieheffekt zu erreichen brauchen wir mindestens 2x24 Stunden, 
# da am Anfang noch zu wenig Punkte in der Grafik sind um einen schnen Effekt 
# zu erreichen. $durchlauf zhlt die Durchlufe. 
$durchlauf=1; 

while($durchlauf<3) { 

# Die entsprechenden Daten (Geo-Position, Uhrzeit, und Line) von der Datenbank holen. 
    my $sth= $dbh->prepare(
        "select longi,lati,uhrzeit,linie from oeffi order by uhrzeit asc"
    ); 
    $sth->execute; 
 
    while(($longi,$lati,$uhrzeit,$linie)=$sth->fetchrow_array) { 
 
# Eine neue Uhrzeit bedeutet, die alte Grafik mit einem Gaussion-Blur zu 
# versehen (damit entsteht dieser Nachzieh-Effekt). Dann wird eine Kopie der 
# Grafik erstellt, um mit Normalize wieder die volle Bandbreite des Fabraumes 
# zu nutzen. Diese Kopie wird auch abgespeichert, whrend das Original mit 20% 
# Schwarz abgedunkelt wird, um diesen Nachzieheffekt zu verstrken. 
# Natrlich wird auch die neue Uhrzeit gespeichert und die Imagenummer erhht. 
        if ($uhrzeit_alt!=$uhrzeit) { 
            $uhrzeit_alt=$uhrzeit; 
            $image->GaussianBlur(radius=>4, sigma=>1000); 
            my $temp1=$image->clone(); 
            my $temp1->Normalize(); 
            $temp1->Write('png:'.$folder.$imagenummer.'.png'); 
            $image->Colorize(fill=>'black',opacity=>'20%'); 
            $imagenummer++; 
        } 
 
# Die entsprechende X und Y Koordinate in der Grafik fr die Geoposition 
# berechnen, mit leichten Anpassungen. 
        $x=int((($longi-$longimin)/$xpixel)+int(($neue_breite-$breite)/2))+25; 
        $y=int((($latimax-$lati)/$ypixel)+int(($neue_hoehe-$hoehe)/2)*$aspect)+5; 
 
# Wenn in Wien eine Linie auf "A" endet ist sie ein Autobus und bekommt die 
# Farbe Rot, wenn die Linie mit "N" anfngt bekommt sie die Farbe Grn und 
# Straenbahnen erhalten die Farbe Blau. 
        $color="#0000FF"; 
        if ($linie=~/A/) { $color="#FF0000";} 
        if ($linie=~/N/) { $color="#00FF00"; } 
 
# Damit die Punkte sichtbarer sind wird ein Kreis gezeichnet der einen Radius von 3 Pixel hat. 
        $xmin=$x-1; 
        $xmax=$x+1; 
        $ymin=$y-1; 
        $ymax=$y+1; 
        $image->Draw(
            fill      => $color, 
            primitive => 'circle', 
            points    => $xmin.','.$ymin.' '.$xmax.','.$ymax,
        ); 
    } 
    $durchlauf++; 
} 