﻿// TestSocket.as

package {

	import flash.display.Sprite;
	import flash.events.*;
	import flash.net.XMLSocket;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.geom.Rectangle;

		public class TestSocket extends Sprite {
			
		private var socket:XMLSocket = new XMLSocket();
		private var host:String = "localhost";
		private var secPort:uint = 5005;
		private var mainPort:uint = 5006;
		
		private var infoBox:TextField = new TextField;
		private var dragBox:Sprite = new Sprite;
		private var stageRect:Rectangle;
		
		private var regExp:RegExp = new RegExp(/\[x:(\d+)\]\[y:(\d+)\]/);
				
		public function TestSocket() {
		addChild(infoBox);
		infoBox.x = infoBox.y = 0;
		infoBox.width = stage.stageWidth; infoBox.height = stage.stageHeight;
        infoBox.text = "Die Verbindung zum Server wird hergestellt...";
		
		Security.loadPolicyFile("xmlsocket://" + host + ":" + secPort);
		
       	configureListeners(socket);
        socket.connect(host, mainPort);
		}
		
		
		private function configureListeners(dispatcher:IEventDispatcher):void {
		dispatcher.addEventListener(Event.CLOSE, closeHandler);
		dispatcher.addEventListener(Event.CONNECT, connectHandler);
		dispatcher.addEventListener(DataEvent.DATA, dataHandler);
		dispatcher.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
		dispatcher.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler);
        }
		
		private function closeHandler(event:Event):void {
		infoBox.text = "Verbindung zum Server ist abgebrochen...";
        }

        private function connectHandler(event:Event):void {
		infoBox.text = "Verbindung erfolgreich.";
		init();
        }
		
		private function init():void {
		addChild(dragBox);
		dragBox.graphics.lineStyle(3,0xFF0000);
		dragBox.graphics.beginFill(0x0000FF);
		dragBox.graphics.drawRect(0,0,100,100);
		dragBox.graphics.endFill();
		dragBox.x = 100;
		dragBox.y = 100;
		dragBox.addEventListener(MouseEvent.MOUSE_DOWN, dragStart);
		dragBox.addEventListener(MouseEvent.MOUSE_UP, dragStop);
		stageRect = new Rectangle(0,0,stage.stageWidth-dragBox.width,stage.stageHeight-dragBox.height);
		}
		
		private function dragStart(event:MouseEvent):void {
		dragBox.startDrag(false,stageRect);
		}
		
		private function dragStop(event:MouseEvent):void {
		dragBox.stopDrag();
		var coordX:uint = dragBox.x, coordY:uint = dragBox.y;
		socket.send("[x:"+coordX+"][y:"+coordY+"]");
		}

		private function dataHandler(event:DataEvent):void {
		infoBox.text = "Dateneingang: "+event.data;
		var res:Object = regExp.exec(event.data);
		dragBox.x = res[1]; dragBox.y = res[2];
		}
		
		private function ioErrorHandler(event:IOErrorEvent):void {
		infoBox.text = "Keine Verbindung zum Hauptserver möglich!";
        }


        private function securityErrorHandler(event:SecurityErrorEvent):void {
		infoBox.text = "Keine Verbindung zum Policy-File-Server möglich!";
        }
	}
	
}

