#!/usr/bin/perl

use warnings;
use strict;
use POSIX;
use IO::Socket;
#use lib "/var/www/cgi-bin/POE-1.007/lib";
use lib "c:/strawberry/perl/bin/POE-1.007/lib";
use POE;

my %inbuffer  = ();
my %outbuffer = ();
my @connections = ();

my $xml = '<?xml version="1.0"?><!DOCTYPE cross-domain-policy SYSTEM "/xml/dtds/cross-domain-policy.dtd"><cross-domain-policy><site-control permitted-cross-domain-policies="master-only"/><allow-access-from domain="localhost" to-ports="5006" /></cross-domain-policy>';


POE::Session->create(
	inline_states		=> {
	_start			=> \&main_server_start,
	event_accept		=> \&main_server_accept,
	event_read		=> \&client_read,
	event_write		=> \&client_write,
	event_disconnect	=> \&client_disconnect
	}
);

POE::Session->create(
	inline_states		=> {
	_start			=> \&policy_server_start,
	policy_accept		=> \&policy_server_accept,
	policy_read		=> \&policy_server_read
	}
);

POE::Kernel->run();

sub main_server_start {
print "Starte Hauptserver...\n";
my $server = IO::Socket::INET->new(
		LocalPort => 5006,
		Listen    => 10,
		Reuse     => "yes",
) or die "can't make server socket: $!\n";
$_[KERNEL]->select_read($server, "event_accept");
}

sub main_server_accept {
my ($kernel, $server) = @_[KERNEL, ARG0];
my $new_client = $server->accept();
print "Neuer Client auf Hauptserver wurde akzeptiert!\n";
push(@connections, $new_client);
$kernel->select_read($new_client, "event_read");
}

sub client_read {
my ($kernel, $client) = @_[KERNEL, ARG0];
my $rv = $client->recv(my $data, POSIX::BUFSIZ, 0);

	unless (defined($rv) and length($data)) {
	$kernel->yield(event_disconnect => $client);
	return;
	}
	$inbuffer{$client} .= $data;

	while ($inbuffer{$client} =~ s/(.*\0)//) {
	my $buff = $1;
	print "Dateneingang von Client: $buff\n";

			foreach my $user (@connections) {
				if ($user ne $client) {
				$outbuffer{$user} .= $buff;
				$kernel->select_write($user, "event_write");
				}
			}
	}
}

sub client_write {
my ($kernel, $client) = @_[KERNEL, ARG0];

	unless (exists $outbuffer{$client}) {
	$kernel->select_write($client);
	return;
	}

my $rv = $client->send($outbuffer{$client}, 0);
print "Daten an Client gesendet: $outbuffer{$client}\n";

	unless (defined $rv) {
	return;
	}

	if ( $rv == length($outbuffer{$client}) or $! == POSIX::EWOULDBLOCK) {
	substr($outbuffer{$client}, 0, $rv) = "";
	delete $outbuffer{$client} unless length $outbuffer{$client};
	return;
	}
$kernel->yield(event_disconnect => $client);
}


sub client_disconnect {
my ($kernel, $client) = @_[KERNEL, ARG0];
my @connectionsTemp = ();

foreach my $user (@connections) {
	if ($user ne $client) {
	push(@connectionsTemp, $user);
	}
}

@connections = @connectionsTemp;

delete $inbuffer{$client};
delete $outbuffer{$client};
$kernel->select($client);
close $client;
print "Client auf Hauptserver hat die Verbindung beendet.\n";
}

sub policy_server_start {
print "Start Policy-File Server...\n";
my $server = IO::Socket::INET->new(
		LocalPort => 5005,
		Listen    => 1,
		Reuse     => "yes",
) or die "can't make server socket: $!\n";
$_[KERNEL]->select_read($server, "policy_accept");
}

sub policy_server_accept {
my ($kernel, $server) = @_[KERNEL, ARG0];
my $new_client = $server->accept();
print "Neuer Client auf Policy-File-Server akzeptiert!\n";
$kernel->select_read($new_client, "policy_read");
}

sub policy_server_read {
my ($kernel, $client) = @_[KERNEL, ARG0];
$client->recv(my $data, POSIX::BUFSIZ, 0);
	if ($data eq "<policy-file-request/>\0") {
	print "Policy-File-Request von Client... Sende virtuelles Policy-File!\n";
	$client->send($xml,0);
	}
$kernel->select($client);
close $client;
print "Client auf Policy-File-Server hat die Verbindung beendet.\n";
}



