#!/usr/bin/perl

use strict;
use warnings;
use Image::Compare;

my($cmp) = Image::Compare->new();
$cmp->set_image1(
    img  => '/path/to/some/file.jpg',
    type => 'jpg',
);
$cmp->set_image2(
    img  => 'http://somesite.com/someimage.gif',
);
$cmp->set_method(
    method => &Image::Compare::THRESHOLD,
    args   => 25,
);
if ($cmp->compare()) {
    # The images are the same, within the threshold
}
else {
    # The images differ beyond the threshold
}