#!/usr/bin/perl

use Test::More tests => 2;
use Test::XPath;

my $xml = <<'XML';
<html>
  <head>
    <title>Hello</title>
    <style type="text/css" src="foo.css"></style>
    <style type="text/css" src="bar.css"></style>
  </head>
  <body>
    <h1>Welcome to my lair.</h1>
  </body>
</html>
XML

my $tx = Test::XPath->new( xml => $xml );

$tx->ok( '/html/head', 'There should be a head' );
$tx->is( '/html/head/title', 'Hello', 'The title should be correct' );