#!/usr/bin/perl

use strict;
use warnings;

use Text::Clip;

my $string = <<'POD';
=head1 Titel eines Artikels

hier kommt der Text des Artikels.
Der Artikel soll dann gedruckt
werden.

=head2 Subtitel
POD

my $marker = Text::Clip->new( data => $string )
                       ->find( qr/^=head1\s+/ );
my ($m2, $headline) = $marker->find( qr/\r?\n/, slurp => '[)' );
print "Titel: $headline\n";

my ($m3, $abstract) = $marker->find( qr/^=head2/, slurp => '[)' );
print "Abstract: ", $abstract, "\n";