package Coerce;

use Moose;
use Moose::Util::TypeConstraints;
use DateTime;

subtype 'DateTime' =>
  as 'Object' =>
  where { $_->isa( 'DateTime' ) };

coerce 'DateTime' =>
  from 'Str' =>
  via { 
    my ($day,$month,$year) = split /\./, $_;
    my $obj = DateTime->new( year => $year, month => $month, day => $day );
    $obj;
  };

has published => (
  is => 'rw',
  isa => 'DateTime',
  coerce => 1,
  handles => [ 'year', 'month' ],
);


1;